<?php
require_once '../config/db.php';
$settings = [];
$stmt = $pdo->query('SELECT key_name, value FROM settings');
foreach ($stmt as $row) {
    $settings[$row['key_name']] = $row['value'];
}
// استقبال نموذج التواصل
$success = false;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name']);
    $email = trim($_POST['email']);
    $phone = trim($_POST['phone']);
    $message = trim($_POST['message']);
    $project_id = intval($_POST['project_id'] ?? 0);
    $stmt = $pdo->prepare('INSERT INTO messages (name, email, phone, message, project_id) VALUES (?, ?, ?, ?, ?)');
    $stmt->execute([$name, $email, $phone, $message, $project_id]);
    $success = true;
}
?>
<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تواصل معنا</title>
    <link rel="stylesheet" href="../public/style.css">
    <style>
        body { background: <?= $settings['bg_color'] ?? '#EEEEEE' ?>; font-family: 'Cairo', sans-serif; }
        .navbar { background: <?= $settings['main_color'] ?? '#EA9218' ?>; color: #fff; padding: 12px 0; display: flex; align-items: center; justify-content: space-between; }
        .navbar img { height: 48px; margin-right: 16px; }
        .navbar ul { list-style: none; display: flex; gap: 24px; margin: 0; padding: 0; }
        .navbar li { display: inline; }
        .navbar a { color: #fff; text-decoration: none; font-weight: bold; font-size: 18px; }
        .container { max-width: 700px; margin: 32px auto; background: #fff; border-radius: 8px; box-shadow: 0 0 10px #31384122; padding: 32px; }
        h2 { color: #EA9218; margin-bottom: 16px; text-align: center; }
        .contact-info { margin-bottom: 24px; text-align: center; }
        .contact-info span { display: block; margin-bottom: 6px; color: #3A4750; }
        .contact-form label { color: #3A4750; font-weight: bold; }
        .contact-form input, .contact-form textarea { width: 100%; padding: 8px; margin-bottom: 12px; border: 1px solid #EA9218; border-radius: 4px; }
        .contact-form button { background: #EA9218; color: #fff; border: none; padding: 10px 24px; border-radius: 4px; width: 100%; font-size: 16px; }
        .success { color: #2a8c2a; text-align: center; margin-bottom: 16px; }
        .map-section { text-align: center; margin-top: 32px; }
        .footer { background: <?= $settings['secondary_color'] ?? '#3A4750' ?>; color: #fff; padding: 24px 0; text-align: center; margin-top: 48px; }
        .footer img { height: 40px; margin-bottom: 8px; }
    </style>
</head>
<body>
    <!-- النافبار -->
    <nav class="navbar">
        <div>
            <img src="../assets/<?= htmlspecialchars($settings['logo'] ?? 'logo.png') ?>" alt="شعار الشركة">
        </div>
        <ul>
            <li><a href="index.php">الرئيسية</a></li>
            <li><a href="projects.php">المشاريع</a></li>
            <li><a href="about.php">من نحن</a></li>
            <li><a href="contact.php">تواصل معنا</a></li>
            <li><a href="#" onclick="alert('قريباً!');">تغيير اللغة</a></li>
        </ul>
    </nav>
    <div class="container">
        <h2>تواصل معنا</h2>
        <div class="contact-info">
            <span>الهاتف: <?= htmlspecialchars($settings['phone'] ?? '') ?></span>
            <span>الإيميل: <?= htmlspecialchars($settings['email'] ?? '') ?></span>
            <span>واتساب: <?= htmlspecialchars($settings['whatsapp'] ?? '') ?></span>
            <span>العنوان: <?= htmlspecialchars($settings['address'] ?? '') ?></span>
            <span>أوقات العمل: <?= htmlspecialchars($settings['work_hours'] ?? '') ?></span>
        </div>
        <?php if ($success): ?>
            <div class="success">تم إرسال رسالتك بنجاح! سنقوم بالرد عليك قريباً.</div>
        <?php endif; ?>
        <form class="contact-form" method="post">
            <label>الاسم</label>
            <input type="text" name="name" required>
            <label>البريد الإلكتروني</label>
            <input type="email" name="email" required>
            <label>الهاتف</label>
            <input type="text" name="phone" required>
            <label>رسالتك</label>
            <textarea name="message" rows="3" required></textarea>
            <button type="submit">إرسال</button>
        </form>
        <div class="map-section">
            <?php if (!empty($settings['address'])): ?>
                <iframe src="https://www.google.com/maps?q=<?= urlencode($settings['address']) ?>&output=embed" width="100%" height="300" style="border:0;border-radius:8px;" allowfullscreen="" loading="lazy"></iframe>
            <?php endif; ?>
        </div>
    </div>
    <!-- الفوتر -->
    <footer class="footer">
        <?php if (!empty($settings['logo'])): ?>
            <img src="../assets/<?= htmlspecialchars($settings['logo']) ?>" alt="شعار الشركة">
        <?php endif; ?>
        <div><?= htmlspecialchars($settings['company_name'] ?? 'شركتنا العقارية') ?></div>
        <div>جميع الحقوق محفوظة &copy; <?= date('Y') ?></div>
    </footer>
</body>
</html>
